import 'package:emoji_picker_flutter/emoji_picker_flutter.dart';
import 'package:flutter/material.dart';
import 'package:flutter_spinkit/flutter_spinkit.dart';
import 'package:get/get.dart';
import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/helper/string_format_helper.dart';
import 'package:play_lab/core/utils/dimensions.dart';
import 'package:play_lab/core/utils/my_color.dart';
import 'package:play_lab/core/utils/styles.dart';
import 'package:play_lab/data/controller/tournament/tournament_live_chat_controller.dart';
import 'package:play_lab/view/components/bottom-sheet/bottom_sheet_header_row.dart';
import 'package:play_lab/view/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:play_lab/view/components/custom_text_field.dart';
import 'package:flutter/foundation.dart' as foundation;
import 'package:play_lab/view/components/image/my_image_widget.dart';

class TournamentLiveChatBottomSheetBody extends StatefulWidget {
  final String tournamentId;
  const TournamentLiveChatBottomSheetBody({super.key, required this.tournamentId});

  @override
  State<TournamentLiveChatBottomSheetBody> createState() => _TournamentLiveChatBottomSheetBodyState();
}

class _TournamentLiveChatBottomSheetBodyState extends State<TournamentLiveChatBottomSheetBody> {
  TextEditingController textEditingController = TextEditingController();
  @override
  Widget build(BuildContext context) {
    return GetBuilder<TournamentLiveChatController>(
      builder: (controller) {
        return Container(
          height: MediaQuery.of(context).size.height * 0.7 - 50,
          padding: EdgeInsets.only(bottom: MediaQuery.of(context).viewInsets.bottom),
          child: Padding(
            padding: const EdgeInsets.only(left: 15.0, right: 15, top: 20),
            child: Column(
              children: [
                const BottomSheetHeaderRow(bottomSpace: 15, isShowHeader: false),
                Container(
                  padding: const EdgeInsets.only(bottom: 10),
                  decoration: const BoxDecoration(),
                  child: Row(
                    children: [
                      Expanded(
                        child: CustomTextField(
                          controller: textEditingController,
                          onChanged: (v) {},
                          borderRadius: 20,
                          isShowBorder: false,
                          fillColor: MyColor.secondaryColor,
                          disableBorderColor: MyColor.colorWhite,
                          hintText: MyStrings.message,
                          hintColor: MyColor.colorWhite,
                          contentPadding: const EdgeInsets.symmetric(vertical: 5, horizontal: 15),
                          isShowSuffixIcon: true,
                          inputAction: TextInputAction.send,
                          onSubmit: () {
                            printX(textEditingController.text);
                          },
                          suffixIcon: InkWell(
                            onTap: () {
                              CustomBottomSheet(
                                child: EmojiPicker(
                                  onEmojiSelected: (Category? category, Emoji emoji) {
                                    Get.back();
                                  },
                                  onBackspacePressed: () {
                                    Get.back();
                                  },
                                  textEditingController: textEditingController,
                                  config: Config(
                                    height: 256,
                                    checkPlatformCompatibility: true,
                                    emojiViewConfig: EmojiViewConfig(emojiSizeMax: 28 * (foundation.defaultTargetPlatform == TargetPlatform.iOS ? 1.20 : 1.0)),
                                    viewOrderConfig: const ViewOrderConfig(top: EmojiPickerItem.categoryBar, middle: EmojiPickerItem.emojiView, bottom: EmojiPickerItem.searchBar),
                                    skinToneConfig: const SkinToneConfig(),
                                    categoryViewConfig: const CategoryViewConfig(),
                                    bottomActionBarConfig: const BottomActionBarConfig(),
                                    searchViewConfig: const SearchViewConfig(),
                                  ),
                                ),
                              ).customBottomSheet(context);
                            },
                            child: const Icon(Icons.emoji_emotions, color: MyColor.primaryColor),
                          ),
                        ),
                      ),
                      const SizedBox(width: Dimensions.space10),
                      InkWell(
                        onTap: () {
                          controller.submitComment(id: widget.tournamentId, comment: textEditingController.text).then((v) {
                            textEditingController.text = '';
                          }).catchError((v) {
                            textEditingController.text = '';
                          });
                        },
                        customBorder: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8)),
                        child: Container(
                          padding: const EdgeInsets.all(8),
                          decoration: BoxDecoration(color: MyColor.primaryColor, borderRadius: BorderRadius.circular(8)),
                          child: controller.isSubmitLoading ? SpinKitFadingCircle(color: MyColor.colorWhite, size: 22) : Icon(Icons.send, color: MyColor.colorWhite),
                        ),
                      ),
                    ],
                  ),
                ),
                Expanded(
                  child: SizedBox(
                    child: controller.liveTournamentCommentList.isEmpty
                        ? Center(child: Text(MyStrings.beTheFirstCommenter.tr, style: regularDefault.copyWith()))
                        : ListView.builder(
                            itemCount: controller.liveTournamentCommentList.length,
                            shrinkWrap: true,
                            physics: NeverScrollableScrollPhysics(),
                            itemBuilder: (context, index) {
                              return ListTile(
                                leading: MyImageWidget(
                                  imageUrl: controller.liveTournamentCommentList[index].user?.imageUrl ?? "",
                                  height: 40,
                                  width: 40,
                                  radius: 20,
                                  isProfile: true,
                                ),
                                title: Text(
                                  (controller.liveTournamentCommentList[index].user?.firstName ?? '').toTitleCase(),
                                  style: mulishSemiBold.copyWith(),
                                ),
                                subtitle: Text(
                                  (controller.liveTournamentCommentList[index].comment ?? '').toTitleCase(),
                                  style: regularDefault.copyWith(fontWeight: FontWeight.w300),
                                ),
                              );
                            },
                          ),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }
}
